-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18-log


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;



--
-- Definition of table `cliente`
--

DROP TABLE IF EXISTS `cliente`;
CREATE TABLE `cliente` (
  `idcliente` int(11) NOT NULL AUTO_INCREMENT,
  `Nif` varchar(12) NOT NULL,
  `NombreRazonSocial` varchar(120) NOT NULL,
  `Domicilio` varchar(100) NOT NULL,
  `RestoDomicilio` varchar(100) NOT NULL,
  `Email` varchar(100) NOT NULL,
  PRIMARY KEY (`idcliente`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `cliente`
--

/*!40000 ALTER TABLE `cliente` DISABLE KEYS */;
INSERT INTO `cliente` (`idcliente`,`Nif`,`NombreRazonSocial`,`Domicilio`,`RestoDomicilio`,`Email`) VALUES 
 (1,'00000003M','Cliente 1','C/ del Pino Verde, 1 áéíúó ñ','2045 Madrid','info@fhumanes.com'),
 (2,'00000002E','Cliente 2','Avda. de Gracia, 23','08001 Barcelona','info@fhumanes.com');
/*!40000 ALTER TABLE `cliente` ENABLE KEYS */;


--
-- Definition of table `factura`
--

DROP TABLE IF EXISTS `factura`;
CREATE TABLE `factura` (
  `idfactura` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_idcliente` int(11) NOT NULL,
  `Nif` varchar(12) NOT NULL,
  `NombreRazonSocial` varchar(120) NOT NULL,
  `Domicilio` varchar(100) NOT NULL,
  `RestoDomicilio` varchar(100) NOT NULL,
  `FechaFactura` date NOT NULL,
  `TotalFactura` decimal(12,2) DEFAULT '0.00',
  `Email` varchar(100) NOT NULL,
  PRIMARY KEY (`idfactura`),
  KEY `fk_factura_cliente_idx` (`cliente_idcliente`),
  CONSTRAINT `fk_factura_cliente` FOREIGN KEY (`cliente_idcliente`) REFERENCES `cliente` (`idcliente`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `factura`
--

/*!40000 ALTER TABLE `factura` DISABLE KEYS */;
INSERT INTO `factura` (`idfactura`,`cliente_idcliente`,`Nif`,`NombreRazonSocial`,`Domicilio`,`RestoDomicilio`,`FechaFactura`,`TotalFactura`,`Email`) VALUES 
 (3,1,'00000003M','Cliente 1','C/ del Pino Verde, 1','2045 Madrid','2020-04-09','1047.82','info@fhumanes.com'),
 (4,2,'00000002E','Cliente 2','Avda. de Gracia, 23','08001 Barcelona','2020-04-15','1312.30','info@fhumanes.com'),
 (5,1,'00000003M','Cliente 1','C/ del Pino Verde, 1','2045 Madrid','2019-07-12','1075.75','info@fhumanes.com'),
 (6,1,'00000003M','Cliente 1','C/ del Pino Verde, 1 áéíúó ñ','2045 Madrid','2019-09-13','92.84','info@fhumanes.com');
/*!40000 ALTER TABLE `factura` ENABLE KEYS */;


--
-- Definition of table `invoice_settings`
--

DROP TABLE IF EXISTS `invoice_settings`;
CREATE TABLE `invoice_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `invoice_settings`
--

/*!40000 ALTER TABLE `invoice_settings` DISABLE KEYS */;
INSERT INTO `invoice_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,2,NULL,NULL,'5dieboouy0s3054leclssq0z','{\"gridWidth\":362.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":121.4,\"grid_headcell_field2\":94.4}}','producto'),
 (2,2,NULL,NULL,'5dieboouy0s3054leclssq0z','{\"gridWidth\":484,\"thWidths\":{\"grid_headcell_field\":10,\"grid_headcell_field1\":38,\"grid_headcell_field2\":50,\"grid_headcell_field3\":62,\"grid_headcell_field4\":30,\"grid_headcell_field5\":47,\"grid_headcell_field6\":190}}','linea_factura'),
 (3,2,NULL,NULL,'5dieboouy0s3054leclssq0z','{\"gridWidth\":639.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":78.4,\"grid_headcell_field2\":84.4,\"grid_headcell_field3\":184.4,\"grid_headcell_field4\":125.4}}','cliente'),
 (4,2,NULL,NULL,'5dieboouy0s3054leclssq0z','{\"gridWidth\":688.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":84.4,\"grid_headcell_field2\":66.4,\"grid_headcell_field3\":59.4,\"grid_headcell_field4\":199.4,\"grid_headcell_field6\":67.4,\"grid_headcell_field7\":68.4}}','factura');
/*!40000 ALTER TABLE `invoice_settings` ENABLE KEYS */;



--
-- Definition of table `producto`
--

DROP TABLE IF EXISTS `producto`;
CREATE TABLE `producto` (
  `idproducto` int(11) NOT NULL AUTO_INCREMENT,
  `Nombre` varchar(50) NOT NULL,
  `Precio` decimal(12,2) NOT NULL,
  PRIMARY KEY (`idproducto`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `producto`
--

/*!40000 ALTER TABLE `producto` DISABLE KEYS */;
INSERT INTO `producto` (`idproducto`,`Nombre`,`Precio`) VALUES 
 (1,'Artículo 1','5.21'),
 (2,'Artículo 2','1.25'),
 (3,'Artículo 3','3.00'),
 (4,'Artículo 4','0.58'),
 (5,'Artículo 5','1.00');
/*!40000 ALTER TABLE `producto` ENABLE KEYS */;




--
-- Definition of table `linea_factura`
--

DROP TABLE IF EXISTS `linea_factura`;
CREATE TABLE `linea_factura` (
  `idlinea_factura` int(11) NOT NULL AUTO_INCREMENT,
  `factura_idfactura` int(11) NOT NULL,
  `producto_idproducto` int(11) NOT NULL,
  `Nombre` varchar(50) NOT NULL,
  `Precio` decimal(12,2) NOT NULL,
  `Cantidad` int(11) NOT NULL,
  `Valor` decimal(12,2) NOT NULL,
  PRIMARY KEY (`idlinea_factura`),
  KEY `fk_linea_factura_factura1_idx` (`factura_idfactura`),
  KEY `fk_linea_factura_producto1_idx` (`producto_idproducto`),
  CONSTRAINT `fk_linea_factura_factura1` FOREIGN KEY (`factura_idfactura`) REFERENCES `factura` (`idfactura`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_linea_factura_producto1` FOREIGN KEY (`producto_idproducto`) REFERENCES `producto` (`idproducto`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;


--
-- Dumping data for table `linea_factura`
--

/*!40000 ALTER TABLE `linea_factura` DISABLE KEYS */;
INSERT INTO `linea_factura` (`idlinea_factura`,`factura_idfactura`,`producto_idproducto`,`Nombre`,`Precio`,`Cantidad`,`Valor`) VALUES 
 (1,3,2,'Artículo 2','1.25',10,'12.50'),
 (2,3,3,'Artículo 3','3.00',4,'12.00'),
 (3,3,1,'Artículo 1','5.21',100,'521.00'),
 (4,3,5,'Artículo 5','1.00',500,'500.00'),
 (5,4,1,'Artículo 1','5.21',250,'1302.50'),
 (6,4,5,'Artículo 5','1.00',4,'4.00'),
 (7,3,4,'Artículo 4','0.58',4,'2.32'),
 (8,4,4,'Artículo 4','0.58',10,'5.80'),
 (9,5,1,'Artículo 1','5.21',200,'1042.00'),
 (10,5,2,'Artículo 2','1.25',3,'3.75'),
 (11,5,3,'Artículo 3','3.00',10,'30.00'),
 (12,6,1,'Artículo 1','5.21',12,'62.52'),
 (13,6,4,'Artículo 4','0.58',4,'2.32'),
 (14,6,3,'Artículo 3','3.00',6,'18.00'),
 (15,6,5,'Artículo 5','1.00',10,'10.00');
/*!40000 ALTER TABLE `linea_factura` ENABLE KEYS */;



/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
